﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="OcenaOceny.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.OcenaOceny" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Ocena</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
            $(".btnOtworzGrid").button({ icons: { primary: 'ui-icon-folder-open' } });
            $("#btnPodwladnyWybierz").button({ icons: { primary: 'ui-icon-grip-dotted-horizontal' }, text: false, label: "Wybierz podwładnego dla którego mają być wyświetleni oceniani przez niego pracownicy" });
            $("#btnPodwladnyWyczysc").button({ icons: { primary: 'ui-icon-closethick' }, text: false, label: "Wyczyść podwładnego" });

            $("#dialog-form").dialog({
                autoOpen: false,
                width: 400,
                modal: true,
                position: "top",
                resizable: false

            });
        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <asp:Label ID="lblError" runat="server"></asp:Label>
            <table class="bodyLRT0" border="0" style="width:100%; border-collapse: collapse; border-spacing: 0; padding:0;">
                <tr>
                    <td colspan="11" style="padding:0;"><span style="font-size: 12pt; font-weight: bold">Ocena</span></td>
                </tr>
                <tr>
                    <td style="width: 10%; vertical-align:bottom; padding:0;">
                        <small>
                            <asp:Label ID="Label1" runat="server">Okres od</asp:Label></small><br />
                        <asp:DropDownList ID="ddlRokOd" runat="server" Width="100%">
                        </asp:DropDownList>
                    </td>
                    <td colspan="3" style="width: 20%; vertical-align:bottom; padding:0;">
                        <small>
                            <asp:Label ID="Label2" runat="server">&nbsp;</asp:Label></small><br />
                        <asp:DropDownList ID="ddlMiesiacOd" runat="server" Width="100%">
                            <asp:ListItem Value="1">Styczeń</asp:ListItem>
                            <asp:ListItem Value="2">Luty</asp:ListItem>
                            <asp:ListItem Value="3">Marzec</asp:ListItem>
                            <asp:ListItem Value="4">Kwiecień</asp:ListItem>
                            <asp:ListItem Value="5">Maj</asp:ListItem>
                            <asp:ListItem Value="6">Czerwiec</asp:ListItem>
                            <asp:ListItem Value="7">Lipiec</asp:ListItem>
                            <asp:ListItem Value="8">Sierpień</asp:ListItem>
                            <asp:ListItem Value="9">Wrzesień</asp:ListItem>
                            <asp:ListItem Value="10">Październik</asp:ListItem>
                            <asp:ListItem Value="11">Listopad</asp:ListItem>
                            <asp:ListItem Value="12">Grudzień</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>&nbsp;
                    </td>
                    <td style="width: 10%; vertical-align:bottom; padding:0;">
                        <small>
                            <asp:Label ID="Label3" runat="server">Okres do</asp:Label></small><br />
                        <asp:DropDownList ID="ddlRokDo" runat="server" Width="100%">
                        </asp:DropDownList>
                    </td>
                    <td style="width: 20%; vertical-align:bottom; padding:0;">
                        <small>
                            <asp:Label ID="Label4" runat="server">&nbsp;</asp:Label></small><br />
                        <asp:DropDownList ID="ddlMiesiacDo" runat="server" Width="100%">
                            <asp:ListItem Value="1">Styczeń</asp:ListItem>
                            <asp:ListItem Value="2">Luty</asp:ListItem>
                            <asp:ListItem Value="3">Marzec</asp:ListItem>
                            <asp:ListItem Value="4">Kwiecień</asp:ListItem>
                            <asp:ListItem Value="5">Maj</asp:ListItem>
                            <asp:ListItem Value="6">Czerwiec</asp:ListItem>
                            <asp:ListItem Value="7">Lipiec</asp:ListItem>
                            <asp:ListItem Value="8">Sierpień</asp:ListItem>
                            <asp:ListItem Value="9">Wrzesień</asp:ListItem>
                            <asp:ListItem Value="10">Październik</asp:ListItem>
                            <asp:ListItem Value="11">Listopad</asp:ListItem>
                            <asp:ListItem Value="12">Grudzień</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>&nbsp;
                    </td>
                    <td style="width: 30%; vertical-align:bottom; padding:0;">
                        <small>
                            <asp:Label ID="Label5" runat="server">Status</asp:Label></small><br />
                        <asp:DropDownList ID="ddlStatus" runat="server" Width="100%">
                            <asp:ListItem Value="SAW">Do samooceny(własne)</asp:ListItem>
                            <asp:ListItem Value="SAM">Do samooceny(wszystkie)</asp:ListItem>
                            <asp:ListItem Value="DOO">Do oceny</asp:ListItem>
                            <asp:ListItem Value="NZA" Selected="True">Niezakończone</asp:ListItem>
                            <asp:ListItem Value="ZAK">Zakończona ocena</asp:ListItem>
                            <asp:ListItem Value="WBA">Wszystkie</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td style="width: 10px;">&nbsp;
                    </td>
                    <td style="text-align: right; vertical-align:bottom; padding:0;">
                        <asp:LinkButton ID="btnOdswiez" runat="server" OnClick="btnOdswiez_Click">Odśwież</asp:LinkButton>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="width:15%; padding-bottom:0; padding-top:2px; padding-left:0; padding-right:4px;  vertical-align:bottom; padding:0;">
                        <small>
                            <asp:Label ID="lblNazwisko" runat="server">Nazwisko</asp:Label></small><br />
                        <asp:TextBox ID="tbNazwisko" Width="100%" runat="server"></asp:TextBox>
                    </td>
                    <td>&nbsp;
                    </td>
                    <td style="width:15%; padding-bottom:0; padding-top:2px; padding-left:0; padding-right:4px; vertical-align:bottom; ">
                        <small>
                            <asp:Label ID="lblImie" runat="server">Imię</asp:Label></small><br />
                        <asp:TextBox ID="tbImie" Width="100%" runat="server"></asp:TextBox>
                    </td>
                    <td>&nbsp;
                    </td>
                    <td colspan="2" style="vertical-align:bottom; padding:0;">
                        <small>
                            <asp:Label ID="Label7" runat="server">Jednostka</asp:Label></small><br />
                        <asp:DropDownList ID="ddlJednostka" runat="server" Width="100%">
                        </asp:DropDownList>
                    </td>
                    <td>&nbsp;
                    </td>
                    <td style="padding-bottom:0; padding-top:2px; padding-left:0; padding-right:4px; vertical-align:bottom;">
                        <small>
                            <asp:Label ID="Label6" runat="server">Oceniani przez podwładnego</asp:Label></small><br />
                        <asp:TextBox ID="tbOcenyPodwladnego" Width="100%" runat="server" ReadOnly="True"></asp:TextBox>
                    </td>
                    <td>&nbsp;
                    </td>
                    <td style="text-align: left; vertical-align:bottom; padding:0;">
                        <asp:LinkButton ID="btnPodwladnyWybierz" runat="server" OnClick="btnPodwladnyWybierz_Click"></asp:LinkButton>
                        <asp:LinkButton ID="btnPodwladnyWyczysc" runat="server" OnClick="btnPodwladnyWyczysc_Click"></asp:LinkButton>
                    </td>
                </tr>
            </table>
            <div>
                <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
                    <div style="float: left; position: absolute; bottom: 2px;">
                        <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
                    </div>
                </div>
                <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_OCENY,STATUS,STATUS_NAZWA,IMIE,NAZWISKO,JEDNOSTKA,STANOWISKO,NAZWA_ARKUSZA,OKRES,ID_ARKUSZA,PRAWO_OCENY,PRAWO_SAMOOCENY,WLASNA,ID_PRACOWNIKA,ROK,MIESIAC,MNOZNIK_OCENY,ID_STANOWISKA,EPSILON,OCENA,OCENA_NIEPOMNIEJSZONA,SAMOOCENA,SAMOOCENA_NIEPOMNIEJSZONA,ID_MPZ" AllowPaging="True" OnRowCommand="gvListy_RowCommand" OnRowDataBound="gvListy_RowDataBound">
                    <Columns>
                        <asp:TemplateField ShowHeader="False">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbOtworzGrid" class="btnOtworzGrid" runat="server" CausesValidation="false" CommandName="OTWORZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Otwórz"></asp:LinkButton>
                            </ItemTemplate>
                            <ItemStyle VerticalAlign="Middle" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="OKRES" HeaderText="Okres" SortExpression="OKRES" />
                        <asp:BoundField DataField="NAZWISKO" HeaderText="Nazwisko" SortExpression="NAZWISKO" />
                        <asp:BoundField DataField="IMIE" HeaderText="Imię" SortExpression="IMIE" />
                        <asp:BoundField DataField="OCENA" HeaderText="Ocena" SortExpression="OCENA" />
                        <asp:BoundField DataField="OCENA_NIEPOMNIEJSZONA" HeaderText="Ocena niep." SortExpression="OCENA_NIEPOMNIEJSZONA" />
                        <asp:BoundField DataField="JEDNOSTKA" HeaderText="Jednostka" SortExpression="JEDNOSTKA" />
                        <asp:BoundField DataField="STANOWISKO" HeaderText="Stanowisko" SortExpression="STANOWISKO" />
                        <asp:BoundField DataField="RODZAJ_UMOWY" HeaderText="Rodzaj Umowy" SortExpression="RODZAJ_UMOWY" />
                        <asp:BoundField DataField="STATUS_NAZWA" HeaderText="Status" SortExpression="STATUS_NAZWA" />
                    </Columns>
                    <PagerSettings Position="Top" />
                    <RowStyle CssClass="TableItem" />
                    <SelectedRowStyle CssClass="TableItemSelected" />
                    <HeaderStyle CssClass="TableHeader" />
                    <AlternatingRowStyle CssClass="TableItemAlt" />
                </asp:GridView>
                <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="OCENA_OCENY_LIST" SelectCommandType="StoredProcedure" ConnectionString="" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected" >
                    <SelectParameters>
                        <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                        <asp:ControlParameter ControlID="tbNazwisko" Name="P_NAZWISKO" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                        <asp:ControlParameter ControlID="tbImie" Name="P_IMIE" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                        <asp:ControlParameter ControlID="ddlRokOd" Name="P_ROK" PropertyName="SelectedValue" />
                        <asp:ControlParameter ControlID="ddlMiesiacOd" Name="P_MIESIAC" PropertyName="SelectedValue" />
                        <asp:ControlParameter ControlID="ddlRokDo" Name="P_ROK_DO" PropertyName="SelectedValue" />
                        <asp:ControlParameter ControlID="ddlMiesiacDo" Name="P_MIESIAC_DO" PropertyName="SelectedValue" />
                        <asp:ControlParameter ControlID="ddlStatus" Name="P_STATUS" PropertyName="SelectedValue" Type="String" ConvertEmptyStringToNull="True" />
                        <asp:ControlParameter ControlID="ddlJednostka" Name="P_ID_MPZ" PropertyName="SelectedValue" />                            
                        <asp:SessionParameter Name="P_ID_PRACOWNIKA" SessionField="OCENA_PRZELOZONY_ID_PRACOWNIKA" />
                    </SelectParameters>
                </asp:SqlDataSource>
            </div>
        </div>
    </form>
</body>
</html>
